/*
 * Decompiled with CFR 0.152.
 */
package dev.upcraft.datasync.content;

import com.mojang.serialization.Codec;
import dev.upcraft.datasync.DataSyncMod;
import dev.upcraft.datasync.api.SyncToken;
import dev.upcraft.datasync.content.DataType;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class DataRegistry {
    private static final Map<class_2960, DataType<?>> DATA_TYPES = new HashMap();
    private static final Collection<DataType<?>> VALUES_VIEW = Collections.unmodifiableCollection(DATA_TYPES.values());

    public static <T> SyncToken<T> add(Class<T> type, class_2960 id, Codec<T> codec) {
        if (DATA_TYPES.containsKey(id)) {
            throw new IllegalStateException("Data Type '%s' already registered! (%s)".formatted(id, DATA_TYPES.get(id).type().getName()));
        }
        DataSyncMod.LOGGER.debug("Registering new sync token: {} ({})", (Object)id, (Object)type.getName());
        DataType<T> t = new DataType<T>(type, id, codec);
        DATA_TYPES.put(id, t);
        return t;
    }

    public static int size() {
        return DATA_TYPES.size();
    }

    public static Collection<DataType<?>> values() {
        return VALUES_VIEW;
    }

    @Nullable
    public static DataType<?> getById(class_2960 id) {
        return DATA_TYPES.get(id);
    }
}

